/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.renderers.fda;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.layout.FDAContent;
import com.ibm.psw.wcl.core.layout.IFDAContentCallback;
import com.ibm.psw.wcl.core.layout.WFDALayout;
import com.ibm.psw.wcl.core.markup.WImage;
import com.ibm.psw.wcl.core.markup.WTextComponent;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.output.DocumentFactory;
import com.ibm.psw.wcl.core.renderer.output.IOutput;
import com.ibm.psw.wcl.core.renderer.output.html.HTMLDocumentFragmentWrapper;
import com.ibm.psw.wcl.core.renderer.output.html.IHTMLDocumentFragmentOutput;
import com.ibm.psw.wcl.renderers.core.html.HTMLContainerRenderer;
import java.awt.ComponentOrientation;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLDivElement;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLImageElement;
import org.w3c.dom.html.HTMLScriptElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class CustomFDALayoutRenderer
extends HTMLContainerRenderer {
    private static final String TRACE_MASKD = "XFDARDRD";
    private static final String TRACE_MASKF = "XFDARDRF";
    private static final String TRACE_MASKT = "XFDARDRT";
    public static final String FDA_TABLE_CLASS = "fdatable";
    public static final String FDA_PROPERTIES = "com.ibm.hwmca.fw.servlet.renderers.fda.res.fda";
    public static final String KEY_DEFAULT_TITLE = "DefaultTitle";
    public static final String KEY_DEFAULT_MESSAGE = "DefaultMessage";

    public CustomFDALayoutRenderer() {
        Trace.trace(TRACE_MASKT, "<> customFDALayoutRender");
    }

    public IOutput render(RenderingContext rc, Object renderObject) throws RendererException {
        IOutput out = null;
        try {
            WFDALayout fdaLayout = (WFDALayout)renderObject;
            DocumentFactory df = rc.getDocumentFactory();
            HTMLDocumentFragmentWrapper doc = df.createHTMLDocumentFragmentWrapper();
            ResourceBundle fdaResources = this.getResourceBundle(rc, fdaLayout);
            this.renderFDALayoutScripts(rc, doc, fdaLayout);
            ResourceBundle fdaProperties = null;
            try {
                fdaProperties = ResourceBundle.getBundle(FDA_PROPERTIES, rc.getLocale());
            }
            catch (MissingResourceException mre) {
                throw new RendererException("Missing resources for default FDA text");
            }
            HTMLTableElement tableElement = doc.createTABLEElement();
            tableElement.setClassName(FDA_TABLE_CLASS);
            tableElement.setCellPadding("0");
            tableElement.setCellSpacing("0");
            doc.appendToContentFragment((Node)tableElement);
            HTMLTableRowElement rowElement = doc.createTRElement();
            rowElement.setAttribute("valign", "top");
            tableElement.appendChild(rowElement);
            HTMLTableCellElement contentsElement = doc.createTDElement();
            contentsElement.setAlign(this.getComponentOrientation(rc, (WComponent)fdaLayout).isLeftToRight() ? "left" : "right");
            this.renderCssStyles(rc, (WComponent)fdaLayout, contentsElement, "fda6");
            IOutput childOutput = null;
            WComponent child = null;
            int size = fdaLayout.getChildComponentCount();
            for (int i = 0; i < size; ++i) {
                child = fdaLayout.getChildComponent(i);
                if (!child.isVisible() || (childOutput = child.getOutput(rc)) == null || !(childOutput instanceof IHTMLDocumentFragmentOutput)) continue;
                IHTMLDocumentFragmentOutput hChildOutput = (IHTMLDocumentFragmentOutput)childOutput;
                hChildOutput.appendHeadFragment((Node)doc.getHeadFragment());
                hChildOutput.appendContentFragment((Node)contentsElement);
            }
            if (!fdaLayout.isFDAHidden()) {
                HTMLTableCellElement fdaElement = doc.createTDElement();
                fdaElement.setAttribute("width", "160px");
                rowElement.appendChild(fdaElement);
                this.renderCssStyles(rc, (WComponent)fdaLayout, fdaElement, "fda6");
                Object imageTable = null;
                HTMLDivElement div = null;
                HTMLTableElement divTable = null;
                HTMLTableRowElement titleRow = null;
                HTMLTableCellElement titleCell = null;
                HTMLTableRowElement descriptionRow = null;
                HTMLTableCellElement descriptionCell = null;
                div = doc.createDIVElement();
                fdaElement.appendChild(div);
                div.setAttribute("style", "display:inline");
                div.setAttribute("id", "FDA" + fdaLayout.getID() + "DefaultDiv");
                divTable = doc.createTABLEElement();
                div.appendChild(divTable);
                titleRow = doc.createTRElement();
                divTable.appendChild(titleRow);
                titleCell = doc.createTDElement();
                titleRow.appendChild(titleCell);
                String titleText = fdaProperties.getString(KEY_DEFAULT_TITLE);
                titleCell.appendChild(doc.createTextNode(titleText));
                this.renderCssStyles(rc, (WComponent)fdaLayout, titleCell, "fda2");
                descriptionRow = doc.createTRElement();
                divTable.appendChild(descriptionRow);
                descriptionCell = doc.createTDElement();
                descriptionRow.appendChild(descriptionCell);
                String defaultDescription = null;
                defaultDescription = fdaLayout.getDefaultDescription();
                if (defaultDescription == null) {
                    defaultDescription = "";
                }
                HTMLElement spanElement = doc.createSPANElement();
                spanElement.setAttribute("class", "txt");
                String titleMessage = fdaProperties.getString(KEY_DEFAULT_MESSAGE);
                spanElement.appendChild(doc.createTextNode(titleMessage));
                descriptionCell.appendChild(spanElement);
                HTMLImageElement imgElement = doc.createIMGElement();
                imgElement.setSrc("/res/com/ibm/hwmca/fw/images/300trans.gif");
                imgElement.setWidth("150");
                imgElement.setHeight("1");
                spanElement.appendChild(imgElement);
                this.renderCssStyles(rc, (WComponent)fdaLayout, descriptionCell, "fda3");
                HashMap<String, FDAContent> contentMap = null;
                contentMap = new HashMap<String, FDAContent>();
                IFDAContentCallback contentCallback = null;
                WTextComponent description = null;
                String title = null;
                int callbacksSize = fdaLayout.getContentCallbackCount();
                for (int i = 0; i < callbacksSize; ++i) {
                    contentCallback = fdaLayout.getContentCallback(i);
                    if (contentCallback == null) continue;
                    Vector fdaContents = null;
                    fdaContents = contentCallback.getFDAContents(rc);
                    if (fdaContents == null) continue;
                    for (int j = 0; j < fdaContents.size(); ++j) {
                        IOutput descriptionOutput;
                        FDAContent currentFDAContent = null;
                        currentFDAContent = (FDAContent)fdaContents.get(j);
                        if (currentFDAContent == null || null != contentMap.put(currentFDAContent.getId(), currentFDAContent)) continue;
                        String descriptionText = currentFDAContent.getFDAText();
                        if (descriptionText == null) {
                            descriptionText = defaultDescription;
                        }
                        if (descriptionText.startsWith("???") && descriptionText.endsWith("???")) {
                            Trace.trace(TRACE_MASKF, "Bad EL expression text value: " + descriptionText);
                            descriptionText = defaultDescription;
                        }
                        description = new WTextComponent(descriptionText);
                        title = currentFDAContent.getFDATitle();
                        if (title == null) {
                            title = "";
                        }
                        if (title.startsWith("???") && title.endsWith("???")) {
                            Trace.trace(TRACE_MASKF, "Bad EL expression title value: " + title);
                            title = "";
                        }
                        div = doc.createDIVElement();
                        fdaElement.appendChild(div);
                        div.setAttribute("style", "display:none");
                        div.setAttribute("id", currentFDAContent.getId() + "Div");
                        divTable = doc.createTABLEElement();
                        div.appendChild(divTable);
                        if (title != null) {
                            titleRow = doc.createTRElement();
                            divTable.appendChild(titleRow);
                            titleCell = doc.createTDElement();
                            titleRow.appendChild(titleCell);
                            titleCell.appendChild(doc.createTextNode(title));
                            this.renderCssStyles(rc, (WComponent)fdaLayout, titleCell, "fda2");
                        }
                        if ((descriptionOutput = description.getOutput(rc)) != null && descriptionOutput instanceof IHTMLDocumentFragmentOutput) {
                            IHTMLDocumentFragmentOutput hDescriptionOutput = (IHTMLDocumentFragmentOutput)descriptionOutput;
                            hDescriptionOutput.appendHeadFragment((Node)doc.getHeadFragment());
                            descriptionRow = doc.createTRElement();
                            divTable.appendChild(descriptionRow);
                            descriptionCell = doc.createTDElement();
                            descriptionRow.appendChild(descriptionCell);
                            hDescriptionOutput.appendContentFragment((Node)descriptionCell);
                        }
                        this.renderCssStyles(rc, (WComponent)fdaLayout, descriptionCell, "fda3");
                    }
                }
            }
            rowElement.appendChild(contentsElement);
            out = doc.createOutput(rc);
        }
        catch (ClassCastException cce) {
            throw new RendererException("Render object is not a WFDALayout.");
        }
        return out;
    }

    protected void renderFDALayoutScripts(RenderingContext rc, HTMLDocumentFragmentWrapper doc, WFDALayout fdaLayout) throws RendererException {
        HTMLScriptElement link = doc.createSCRIPTElement();
        link.setLang("javascript");
        StringBuffer fdaScript = new StringBuffer("");
        String id = fdaLayout.getID();
        fdaScript.append("var ");
        fdaScript.append(rc.encodeName(id));
        fdaScript.append(" = new fdaState('");
        fdaScript.append(id);
        fdaScript.append("', '");
        fdaScript.append("FDA" + id + "DefaultDiv");
        fdaScript.append("');");
        link.appendChild(doc.createTextNode(fdaScript.toString()));
        doc.appendToHeadFragment((Node)link);
    }

    protected void addImage(RenderingContext rc, HTMLDocumentFragmentWrapper doc, WFDALayout fdaLayout, HTMLElement imageTableParent) throws RendererException {
        if (fdaLayout.isFeatureEnabled(1)) {
            HTMLTableElement imageTable = null;
            HTMLTableRowElement imageRow = null;
            HTMLTableCellElement imageCell = null;
            imageTable = doc.createTABLEElement();
            imageTableParent.appendChild(imageTable);
            imageRow = doc.createTRElement();
            imageTable.appendChild(imageRow);
            imageCell = doc.createTDElement();
            imageRow.appendChild(imageCell);
            ResourceBundle fdaResources = this.getResourceBundle(rc, fdaLayout);
            String altText = null;
            altText = fdaLayout.getAltText();
            if (altText == null) {
                fdaLayout.setAltText(fdaResources.getString("ALT_TAG_FDA_IMG_DEFAULT"));
            }
            WImage fdaWImage = fdaLayout.getFDAImage();
            IOutput imageOutput = null;
            if (fdaWImage != null) {
                if (fdaWImage.isVisible()) {
                    if (fdaWImage.getURL(rc) == null || fdaLayout.isDefaultFDAImage()) {
                        boolean isRTL;
                        String imgSrc = null;
                        String imgWidth = null;
                        String imgHeight = null;
                        ComponentOrientation orientation = this.getComponentOrientation(rc, (WComponent)fdaLayout);
                        boolean bl = isRTL = orientation != null && orientation.equals(ComponentOrientation.RIGHT_TO_LEFT);
                        if (isRTL) {
                            imgSrc = this.getImageValue(rc, (WComponent)fdaLayout, "IMG_FDA_DEFAULT_BIDI");
                            imgWidth = this.getImageWidth(rc, (WComponent)fdaLayout, "IMG_FDA_DEFAULT_BIDI");
                            imgHeight = this.getImageHeight(rc, (WComponent)fdaLayout, "IMG_FDA_DEFAULT_BIDI");
                        }
                        if (imgSrc == null) {
                            imgSrc = this.getImageValue(rc, (WComponent)fdaLayout, "IMG_FDA_DEFAULT");
                            imgWidth = this.getImageWidth(rc, (WComponent)fdaLayout, "IMG_FDA_DEFAULT");
                            imgHeight = this.getImageHeight(rc, (WComponent)fdaLayout, "IMG_FDA_DEFAULT");
                        }
                        fdaWImage.setURL(imgSrc);
                        fdaWImage.setWidth(imgWidth);
                        fdaWImage.setHeight(imgHeight);
                    }
                    if ((imageOutput = fdaWImage.getOutput(rc)) != null && imageOutput instanceof IHTMLDocumentFragmentOutput) {
                        IHTMLDocumentFragmentOutput hImageOutput = (IHTMLDocumentFragmentOutput)imageOutput;
                        hImageOutput.appendHeadFragment((Node)doc.getHeadFragment());
                        hImageOutput.appendContentFragment((Node)imageCell);
                    }
                }
            } else {
                HTMLImageElement fdaImg = null;
                fdaImg = doc.createIMGElement();
                fdaImg.setSrc(this.getImageValue(rc, (WComponent)fdaLayout, "IMG_FDA_DEFAULT"));
                fdaImg.setAlt(altText);
                fdaImg.setWidth(this.getImageWidth(rc, (WComponent)fdaLayout, "IMG_FDA_DEFAULT"));
                fdaImg.setHeight(this.getImageHeight(rc, (WComponent)fdaLayout, "IMG_FDA_DEFAULT"));
                imageCell.appendChild(fdaImg);
            }
            this.renderCssStyles(rc, (WComponent)fdaLayout, imageCell, "fda1");
        }
    }

    protected ResourceBundle getResourceBundle(RenderingContext rc, WFDALayout fdaLayout) {
        ResourceBundle fdaResources = fdaLayout.getResourceBundle();
        if (fdaResources == null || !fdaResources.getLocale().equals(rc.getLocale())) {
            fdaResources = ResourceBundle.getBundle("com.ibm.psw.wcl.nls.WclFDALayoutResources", rc.getLocale());
            fdaLayout.setResourceBundle(fdaResources);
        }
        return fdaResources;
    }
}

